<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Career extends Model 
{

    protected $table = 'careers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'name_ar', 'description', 'description_ar', 'is_active');

    public function careerRequests()
    {
        return $this->hasMany('App\Models\CareerRequest');
    }

}